;
; The Ultimate Lieves!Tuore Player (TULTP)
;
;   versio 1.0 sigmaomega
;
; teki Yzi/L!T 2-8. huhtikuuta 1997
;
;	"T on tmmnen hassu projekti hmm."
;                               -Marq
;
; featuring:
;       - 3 kanavaa
;       - adsr -kyrt
;       - 16 instrumenttia
;             - adsr, volume, arpeggiot, noise/tone, slide
;       - yli 5 oktaavia (64 svelt)
;       - raitoja ja patterneja
;             - raidat eli kanavat itsenisi
;       - mahdollisuudet ssteliseen
;         sveltmiseen (_iso_ biisi < 4kB)
;       - komentoja sun muuta:
;             - slide up&down
;             - delay
;             - portamento
;             - vibrato
;             - track loop
;             - tempo
;       - kehitetty fmsx-emulaattorin avulla
;       - tekijns ihka ensimminen Z80-ohjelma
;             - varmaankin mielenkiintoista koodia
;

; offsetit kanavien parametreihin
#DEFINE CHN_INSTRUMENT  0
#DEFINE CHN_SONGPTR     2
#DEFINE CHN_PATTERNPTR  4
#DEFINE CHN_FINE        6
#DEFINE CHN_COARSE      7
#DEFINE CHN_TARGET_FINE 8
#DEFINE CHN_TARGET_COARSE 9
#DEFINE CHN_LEVEL       10
#DEFINE CHN_ADSR        11
;adsr:vaihe, eli ollanko kohdassa a,d,s vai r
#DEFINE CHN_ARPIDX      12
#DEFINE CHN_TEMPO       13
#DEFINE CHN_DELAY       14
#DEFINE CHN_STOPPED     15
#DEFINE CHN_NOTE        16
; delta tuning, eli slide varten muutokset, jotka pidetn tallessa
#DEFINE CHN_DELTA_FINE  17
#DEFINE CHN_DELTA_COARSE 18
#DEFINE CHN_VIBIDX      19
#DEFINE CHN_VIBSPD      20
; mihin on laitettu looppi
#DEFINE CHN_REPEAT      21
#DEFINE CHN_REPEAT_PTR  22
; pointteri joka kertoo miss on tunings-taulukko
#DEFINE CHN_NOTE_TABLE  24
#DEFINE CHN_SLIDE_FINE  26
#DEFINE CHN_SLIDE_COARSE 27

;offsetit instrumenttiin
#DEFINE INS_LEVEL       0
#DEFINE INS_ATTACK      1
#DEFINE INS_DECAY       2
#DEFINE INS_SUSTAIN     3
#DEFINE INS_RELEASE     4
#DEFINE INS_MODE        5
; arplen -tavun ylimmss neljss bitiss on sliden nelj ylint bitti
#DEFINE INS_ARPLEN      6
#DEFINE INS_SLIDE       7
#DEFINE INS_NOISE_SLIDE 8
#DEFINE INS_ARPEGGIO    9

; komennot patternilistassa ("song order")
#DEFINE TRACK_STOP      255
#DEFINE TRACK_SETREPEAT 254
#DEFINE TRACK_REPEAT    253
#DEFINE TRACK_INF 255

#DEFINE VIIMPATT        ((viimeinenp-pattern_addr)/2)

; komentojen nimet
#include "commands.inc"

; ------------------ ALKAA TST! ------------------

.org    1024
	di			;	Asetetaan oma handleri! Jesh!
        ld      hl,musa_handu
        ld      (38h+1),hl
        ld      a,0c3h
        ld      (38h),a
	ei
        ret

.org    1100
; *** Myhempi lisys ***
VDP_reg .db     8
VDP_dat .db     0
vitutus .db     1
; *** Myhempi lisys loppuu ***

; ******* muuttujia *********
; [Marq] Oli 8-bittinen save_hl!
kanava          .db     0  ; kanavan numero, jota ksitelln (0-2)
save_hl         .dw     0
kanava_insptr   .dw     instrumentit
apuwoorti       .dw     0
apumuuttuja     .dw     0

#include "msxfreq.txt"

; ------------------- **** aliohjelmia **** -------------------

; ----------- SET CHANNEL VOLUME -------------
; asettaa kanavalle [kanava]
; voimakkuuden [a], 4:4-bittinen luku!
; tuhoaa rekisterien a ja b sislln
set_channel_volume:
        ld      b, a
        ld      a, (kanava)     ; PSG reg. 8-10: volume ch. 0-2
	add	a, 8
	out	(0A0h), a
	ld	a, b
	srl	a
	srl	a
	srl	a
	srl	a		; otetaan 4 ylint bitti
	out	(0A1h), a
	ret

; ----------- SET CHANNEL TUNING -------------
; asettaa kanavalle [kanava]
; taajuuden [b,c] eli b=coarse, c=fine
; tuhoaa rekisterien a ja d sisllt
set_channel_tuning:
        ld      a, (kanava)     ; PSG reg. 0-5: tuning ch. 0-2
	sla	a		; a=kanava*2
        ld      d, a            ; kanava*2 talteen
        out     (0A0h), a       ; fine freq.
	ld	a, c
	out	(0A1h), a
	ld	a, d
        inc     a               ; a=kanava*2+1
	out	(0A0h), a	; coarse, PSG reg (ch+1)
	ld	a, b
	out	(0A1h), a
	ret

; --- iy := 2 * akku
iy_2a: ; yleishydyllinen rutiini...
        sla     a       ; kerrotaan kahdella (16 bits/tuning)
        ld      (apuwoorti), a
        sub     a
        ld      (apuwoorti+1), a
        ld      iy, (apuwoorti)
        ret

; ---------- LISAA_VIBRATON_TAAJUUS ---------------
; lis akussa olevan nuotin taajuuden rekisteriin bc
; tuhoaa rekisterit a, b, c ja iy (?)
lisaa_vibraton_taajuus:
        ld      a, (ix+CHN_VIBSPD)
        cp      0
        jp      z, ei_nyt_oo_vibrato_paalla
        ld      a, (ix+CHN_VIBIDX)
        call    iy_2a ; iy := 2 * a
        ;haetaan tuning-taulukosta oikeat arvot
        ld      de, vibrato_table
        add     iy, de          ;iy=offset vibrato_table + vibidx * 2
        ld      a, c
        add     a, (iy)
        ld      c, a
        ld      a, b
        adc     a, (iy+1)
        ld      b, a
ei_nyt_oo_vibrato_paalla:
        ret
; end - lisaa_vibraton_taajuus      ---- tuhoaa iy:n!

; ---------- HAE_NUOTIN_TAAJUUS ---------------
; hakee akussa olevan nuotin taajuuden rekisteriin bc
; tuhoaa rekisterit a, b, c ja iy
hae_nuotin_taajuus:
        call    iy_2a  ; iy := 2 * a
        ;haetaan tuning-taulukosta oikeat arvot
        ld      bc, tunings
        add     iy, bc          ;iy=offset tunings + nuotti * 2
        ld      a, (iy)         ;bc=tuning (12-bittinen)
        add     a, (ix+CHN_DELTA_FINE)
        ld      c, a
        ld      a, (iy+1)
        adc     a, (ix+CHN_DELTA_COARSE)
        ld      b, a
        ret
; end - hae_nuotin_taajuus      ---- tuhoaa iy:n!

; ----------- ASETA NUOTTI -------------------
; asettaa akussa olevan nuotin taajuuden kanavalle
; tuhoaa rekisterit a, b, c, d ja iy
aseta_nuotti:
        call    hae_nuotin_taajuus ; tuhoaa iy:n
        call    lisaa_vibraton_taajuus
        call    set_channel_tuning
        ret
; end - aseta_nuotti       --- IY TUHOTTU !!!!!!

; -------------- SET CHANNEL INSTRUMENT ---------------
; asettaa kanavalle instrumentin a, (NUMERO ON AKUN 4 YLIMMSS BITISS!!)
; IX osoittaa kanavan parametrien alkuun
; lopussa HL osoittaa instrumenttiin, samoin kuin IY
set_channel_instrument:
        ld      c, a
        ld      b, 0
        ld      hl, instrumentit
        add     hl, bc  ; hl osoittaa instrumenttiin
        ld      (ix), l
        ld      (ix+1), h ; asetetaan instrumentti
        ld      (kanava_insptr), hl
        ld      iy, (kanava_insptr)

        ; nollataan kanavan muuttujat
        sub     a ; a := 0
        ld      (ix+CHN_ADSR), a
        ld      (ix+CHN_LEVEL), a
        ld      (ix+CHN_ARPIDX), a
        ld      (ix+CHN_DELTA_FINE), a
        ld      (ix+CHN_DELTA_COARSE), a
        ld      (ix+CHN_VIBIDX), a
        ld      (ix+CHN_VIBSPD), a
        ld      (ix+CHN_SLIDE_FINE), a
        ld      (ix+CHN_SLIDE_COARSE), a

; onko noise enable?
        ld      a, (iy+INS_MODE)
        ld      b, 9    ; b = mask
        and     b
        ld      c, a    ; c = noise&tone enable

        ld      a, 7 ; mixer
        out     (0A0h), a

        ld      a, (kanava)
        cp      0
        jp      z, ouagadougou
        sla     c
        sla     b
        cp      1
        jp      z, ouagadougou
        sla     c
        sla     b
ouagadougou:
        ld      a, b
        xor     255
        ld      b, a
        in      a, (0A2h)
        and     b
        xor     c

        out     (0A1h), a

        ret
; end - set_channel_instrument

paivita_adsr:
; --------------- PIVIT ADSR ------------------
; kanavan adsr etenee kivasti
; IX:kanava
; IY:instrumentti
        ld      a, (ix+CHN_ADSR)
        cp      0
        jp      nz, ei_attack
; ---------- attack-vaihe --------------
        ld      a, (ix+CHN_LEVEL)
        add     a, (iy+INS_ATTACK) ;meneek yli 255:st?
        jp      nc, k1va
        ld      a, (iy+INS_LEVEL) ;meni - laitetaan oikea leveli.
        inc     (ix+CHN_ADSR)
        jp      ookkei
k1va:   cp      (iy+INS_LEVEL) ;onko ins_level suurempi kuin akku(=chn_level)?
        jp      c, ookkei
        ;akku on suurempi - laitetaan ins_level ja mennn eteenpin adsr:ss
        ld      a, (iy+INS_LEVEL)
        inc     (ix+CHN_ADSR)
        jp      ookkei
ei_attack:
        cp      1 ; onko CHN_ADSR 1?
        jp      nz, ei_decay
; ---------- decay-vaihe ---------------
        ld      a, (ix+CHN_LEVEL)
        sub     (iy+INS_DECAY)
        jp      nc, k1va2 ; menik alle nollan?
        ld      a, (iy+INS_SUSTAIN)
        inc     (ix+CHN_ADSR)
        jp      ookkei
k1va2:  cp      (iy+INS_SUSTAIN)
        jp      nc, ookkei ; onkos ins_sustain pienempi kuin chn_level?
        ; meni yli - laitetaan ins_sustain ja mennn eteenpin adsr:ss
        ld      a, (iy+INS_SUSTAIN)
        inc     (ix+CHN_ADSR)
        jp      ookkei
ei_decay:
        cp      2 ; onko CHN_ADSR 2?
        jp      nz, ei_sustain
; --- sustain-vaihe (ei tehd mitn) --
        ret
ei_sustain:
        cp      3 ; onko CHN_ADSR 3? (release
        jp      nz, ei_release
; release-vaihe (pienennetn leveli nollaan)
        ld      a, (ix+CHN_LEVEL)
        sub     (iy+INS_RELEASE)
        jp      nc, ookkei ; menik yli?
        sub     a ; yli meni, a:=0
        inc     (ix+CHN_ADSR) ; eteenpin, eli CHN_ADSR := 4  (loppu)
        jp      ookkei
ei_release: ; koko adsr on loppunut - ei tehd mitn
        ret
ookkei: ld      (ix+CHN_LEVEL), a
        call    set_channel_volume
        ret

; end - paivita_adsr

; ------ PAIVITA ARPEGGIO ---------------
; Etenee arpeggioissa ja asettaa oikean
; svelen kanavalle
; tuhoaa rekisterit   a, b, c, d, hl, iy
paivita_arpeggio:
        ld      a, (ix+CHN_ARPIDX)
        inc     a
        cp      (iy+INS_ARPLEN)
        jp      nz, ohi_tuskaista
        sub     a
ohi_tuskaista:
        ld      (ix+CHN_ARPIDX), a

        ld      c, a
        sub     a
        ld      b, a    ; bc = offsetti ins_arpeggio-taulukkoon

; iy tuhoutuu nytten:
        add     iy, bc
        ld      a, (ix+CHN_NOTE)
        add     a, (iy+INS_ARPEGGIO)
        call    aseta_nuotti ; tuhoaa iy:n !
        ret
; end - paivita_arpeggio      TUHOAA IY:N !!!


; ------ PAIVITA INS SLIDE -------------------
; tuhoaa rekisterit a, b, c, hl
paivita_ins_slide:
        ld      a, (iy+INS_SLIDE)
        cp      0
        jp      z, ei_mitaan_ins_slidea
        ld      l, (ix+CHN_DELTA_FINE)
        ld      h, (ix+CHN_DELTA_COARSE)
        ld      c, a
#ifdef SLIDE_12BIT
        ld      b, (iy+INS_ARPLEN)
        srl     b
        srl     b
        srl     b
        srl     b
#else
        sub     a
        ld      b, a
#endif
        add     hl, bc
        ld      (ix+CHN_DELTA_FINE), l
        ld      (ix+CHN_DELTA_COARSE), h        ; delta_tuning += ins_slide
ei_mitaan_ins_slidea:
        ret
; end - paivita_ins_slide

; ------ PAIVITA SLIDE -------------------
; tuhoaa rekisterit a, b, c, hl
paivita_slide:
        ld      a, (ix+CHN_SLIDE_FINE)
        cp      0
        jp      z, ei_mitaan_slidea
        ld      l, (ix+CHN_DELTA_FINE)
        ld      h, (ix+CHN_DELTA_COARSE)
        ld      c, a
        ld      b, (ix+CHN_SLIDE_COARSE)
        add     hl, bc
        ld      (ix+CHN_DELTA_FINE), l
        ld      (ix+CHN_DELTA_COARSE), h        ; delta_tuning += chn_slide
ei_mitaan_slidea:
        ret
; end - paivita slide


; ------------ PAIVITA VIBRATO -----------------
; tuhoaa akun
paivita_vibrato:
        ld      a, (ix+CHN_VIBIDX)      ; vibidx = (vibidx+vibspd) AND 63
        add     a, (ix+CHN_VIBSPD)
        and     63
        ld      (ix+CHN_VIBIDX), a
        ret


#include "mul4.inc"

seuraava_tavu: ; kasvattaa hl: ja laittaa uuden arvon (ix+CHN_PATTERNPTR):n
        inc     hl
        ld      (ix+CHN_PATTERNPTR), l
        ld      (ix+CHN_PATTERNPTR+1), h
        ret

song_seuraava_tavu:
        inc     hl ; seuraava patterni, kiitos!
        ld      (ix+CHN_SONGPTR), l
        ld      (ix+CHN_SONGPTR+1), h
        ret

; ---------- SET DELAY
; asettaa akussa olevan delayn
; CHN_DELAY = CHN_TEMPO * a
; tuhoaa rekisterit a, b ja c
set_delay:
        and     15
        ld      c, a
        ld      b, (ix+CHN_TEMPO)
        call    mul4
        ld      (ix+CHN_DELAY), a
        ret

; ---------------- KSITTELE KANAVA ----------------------------------------
; IX osoittaa kanavan parametreihin
; (tuhoaa kaikki rekisterit...)
kasittele_kanava:
        ld      a, (ix+CHN_STOPPED)
        cp      1
        jp      nz, im_still_standing_yeah_yeah_yeah
        ret
im_still_standing_yeah_yeah_yeah:

; luetaan kanavan instrumenttiosoitin iy:hyn
        ld      l, (ix)         ; iy := (ix+0) (kanavan instrumentti)
        ld      h, (ix+1)
        ld      (kanava_insptr), hl   ; talletetaan iy
        ld      iy, (kanava_insptr)

; pienennetn delayta ja jos ei ole nolla, odotellaan
        dec     (ix+CHN_DELAY)
        jp      nz, orotellaas_vaha

; ei en vivett -> mennn eteenpin
jatkuujatkuujatkuu:
        ld      iy, (kanava_insptr)   ; huom! set_instr asettaa tmn mys
        ld      l, (ix+CHN_PATTERNPTR)    ; patternpointeri kanavan
        ld      h, (ix+CHN_PATTERNPTR+1)  ; parametreista
        ld      a, (hl) ; luetaan komento
        ld      c, a    ; laitetaan se viel cee-rekisteriinkin
        and     192     ; otetaan bitit 6 ja 7
        cp      0       ; tutkitaan kahta ylint bitti
        jp      z, se_on_nuoatti ; se on nuatti!
        cp      64
        jp      z, se_on_portamento ; se on porttamentto!
        cp      128
        jp      z, se_on_tempo ; se on temppo!
        cp      192
        jp      z, se_on_komento ; se on koomentto!
        ; muita vaihtoehtoja ei ollutkaan

orotellaas_vaha: ; --- CHN_DELAY oli > 0 ---
        call    paivita_vibrato
        call    paivita_ins_slide
        call    paivita_slide
        call    paivita_arpeggio ; tuhoaa iy:n!
orottelu: ; thn tullaan 0-tickistkin, eli arpeggioita ei pivitet silloin
          ; mutta adsr:t pivitetn (ettei tule 1. ticki nollaksi)
        ld      iy, (kanava_insptr)
        call    paivita_adsr
        ret     ; paluu kasittele_kanava -rutiinista!!

kattotaas_ny: ; ----- komento on nyt ksitelty ----
        ; ei lopeteta, ennenkuin CHN_DELAY > 0
        ld      a, (ix+CHN_DELAY)
        cp      0
        jp      z, jatkuujatkuujatkuu   ; jos CHN_DELAY = 0, jump
        jp      orottelu ; muuten odotellaan

; -------- UUSI NUOTTI -------
se_on_nuoatti: ; tavun kaksi ylint bitti 00
        ld      a, c    ; akussa on nuotin numero
        ld      (ix+CHN_NOTE), a        ; nuotti talteen arpeggioita varten

        call    seuraava_tavu   ;hl+=1
        ld      a, (hl)
        ld      (save_hl), hl   ; set_channel_instrument tuhoaa hl:n
        and     240     ; nelj ylint bitti = instrumentti
        ; akkua ei tarvitse shiftata (ks. set_channel_instrument)
        call    set_channel_instrument
        ld      hl, (save_hl)

nuotin_asetus: ; thn hyptn portamentosta
        ld      a, (hl)
        and     15      ; nelj alinta bitti = viive
        call    set_delay ; asettaa delayn akusta

        ; Nuotti pitpi asettaa instrumentin jlkeen, koska
        ; siin tarvitaan instrumentin tietoja (INS_SLIDE)
        ld      a, (ix+CHN_NOTE)
        call    aseta_nuotti
        ; iy on tuhottu!!!!!

        call    seuraava_tavu ; ksittelyn jlkeen hl osoittaa uuteen tavuun
        jp      kattotaas_ny
; ----------- TEMPO ----------
se_on_tempo: ; asettaa
        ld      a, c
        and     15
        ld      (ix+CHN_TEMPO), a
        call    seuraava_tavu
        jp      kattotaas_ny
; -------- PORTAMENTO --------
se_on_portamento: ; ei mitn monimutkaisia portamentoja
        ; portamento asettaa pelkn nuotin, ei instrumenttia
        ld      a, c
        and     63
        ld      (ix+CHN_NOTE), a
        sub     a
        ld      (ix+CHN_SLIDE_FINE), a
        ld      (ix+CHN_SLIDE_COARSE), a
        ld      (ix+CHN_DELTA_FINE), a
        ld      (ix+CHN_DELTA_COARSE), a
        call    seuraava_tavu
        jp      nuotin_asetus ; kytetn uudestaan uusi nuotti -kohdan koodia

; ---------- KOMENTO ---------
se_on_komento: ; komento onkin komento. hmm....
        ld      a, c
        cp      END_PATTERN
        jp      z, lopeta_pattern
        cp      NOTE_OFF
        jp      z, nuatti_pois
        cp      DELAY
        jp      z, viiive
        cp      VIBRATO
        jp      z, vipraatto
        cp      SLIDE_UP
        jp      z, ylamaki
        cp      SLIDE_DOWN
        jp      z, alamaki
asia_on_loppuunkasitelty: ; <--- thn tullaan komentojen ksittelyist <---
        call    seuraava_tavu
        jp      kattotaas_ny

lopeta_pattern:
        ld      l, (ix+CHN_SONGPTR)
        ld      h, (ix+CHN_SONGPTR+1)
        ; hl -> patternilistaan
track_jatkuujatkuujatkuu:
        call    song_seuraava_tavu
        ld      d, 0
        ld      e, (hl)
        ld      a, e    ; onko song order -komento
        cp      TRACK_STOP
        jp      z, maailmanloppu
        cp      TRACK_SETREPEAT
        jp      z, trak_set_repeat
        cp      TRACK_REPEAT
        jp      z, trak_repeat

        ; ei ollut song order -komento, joten se on patternin numero
        sla     e       ; de=patternin numero * 2

        ld      iy, pattern_addr
        add     iy, de  ; iy -> pattern_addr[pnumero*2]

        ld      l, (iy)
        ld      h, (iy+1)       ; hl -> uusi patterni
        ld      (ix+CHN_PATTERNPTR), l
        ld      (ix+CHN_PATTERNPTR+1), h

; [Marq] TM oli vaikea lyt, mutta kun hyptn asia_on_loppuunkasitel-
; tyyn, niin siellhn listn hooll, jolloin patterni on vrss
; kohdassa! !!!    !  Siksip sit pienennetn.

        dec     hl
        jp      asia_on_loppuunkasitelty

nuatti_pois: ; ----- NOTE OFF --------

        ld      (ix+CHN_ADSR), 3 ; asetetaan chn_adsr := 3 (release)
viiive: inc     hl      ; seuraava tavu: note offin viive
        ld      a, (hl)
        and     15
        call    set_delay
        jp      asia_on_loppuunkasitelty

vipraatto: ; ------ VIBRATO -------
        inc     hl
        ld      a, (hl)
        ld      (ix+CHN_VIBSPD), a
        jp      asia_on_loppuunkasitelty

ylamaki: ; ------- SLIDE UP -------
        inc     hl
        ld      a, (hl)
        neg
        ld      (ix+CHN_SLIDE_FINE), a
        ld      a, 255
        ld      (ix+CHN_SLIDE_COARSE), a
        jp      viiive
alamaki: ; ------ SLIDE DOWN ------
        inc     hl
        ld      a, (hl)
        ld      (ix+CHN_SLIDE_FINE), a
        sub     a
        ld      (ix+CHN_SLIDE_COARSE), a
        jp      viiive

; ------------- song order -komennot: ----------------------------

maailmanloppu: ; ---------- raita loppui
               ; thn tullaan, kun songlistiss on TRACK_STOP
               ; eli lopetetaan soitto ja asetetaan CHN_STOPPED := 1
        ld      a, 1
        ld      (ix+CHN_STOPPED), a
        ret

trak_set_repeat:
; laitetaan muistiin HL:n arvo repeatia varten
; tmn jlkeen jatketaan patternien soittamista
        ld      (ix+CHN_REPEAT_PTR), l
        ld      (ix+CHN_REPEAT_PTR+1), h
        jp      track_jatkuujatkuujatkuu

trak_repeat: ; nyt tytyy hypt taaksepin songorderissa
        ld      a, (ix+CHN_REPEAT)
        cp      0
        jp      nz, pienennys
        ; CHN_REPEAT = 0 : aloitetaan looppi
        inc     hl
        ld      a, (hl)
        jp      song_order_hyppy
pienennys: ; CHN_REPEAT ei ollut nolla


; *** Piti vhn kikkailla ***
        cp      TRACK_INF
        jp      z,song_order_hyppy

        dec     a
        jp      z, repeatin_ohitus  ; CHN_REPEAT oli 1 : mennn eteenpin
; *** Lopajaa ***

        ; CHN_REPEAT oli >1 : tehdn hyppy songorderissa
song_order_hyppy:
        ld      (ix+CHN_REPEAT), a
        ld      l, (ix+CHN_REPEAT_PTR)  ; hyppy: haetaan hl:lle uusi arvo
        ld      h, (ix+CHN_REPEAT_PTR+1)
;        inc     hl
        jp      track_jatkuujatkuujatkuu

repeatin_ohitus:
        ld      (ix+CHN_REPEAT), a ; akussa nolla
        inc     hl ; repeatin parametri ohi
        jp      track_jatkuujatkuujatkuu




; ---------------------------------------- o,o ------------- HANDLERI ------
;                                          -=-
; ***** Interruptihandleri *****

musa_handu:
        PUSH    AF
        PUSH    BC
        PUSH    DE
        PUSH    HL
        PUSH    IX
        PUSH    IY

        in      a,(99h)         ;       ACKnowledge vai?

; *** TM ON VAIN INTROSSA ***

        ld      a,(vitutus)
        dec     a
        jp      z,parkkiintunut
        ld      (vitutus),a

parkkiintunut:
        ld      a,(VDP_reg)
        cp      8
        jp      z,ohes
        ld      a,(VDP_dat)
        out     (99h),a
        nop
        ld      a,(VDP_reg)
        or      080h
        out     (99h),a
        ld      a,8
        ld      (VDP_reg),a
ohes:
; *** THN lopahtaa ***

        sub     a
        ld      (kanava), a
        ld      ix, kanavan_0_parametrit
        call    kasittele_kanava

        ld      a, 1
        ld      (kanava), a
        ld      ix, kanavan_1_parametrit
        call    kasittele_kanava

        ld      a, 2
        ld      (kanava), a
        ld      ix, kanavan_2_parametrit
        call    kasittele_kanava

pojes:  POP     IY
        POP     IX
        POP     HL
        POP     DE
        POP     BC
        POP     AF

	ei
	reti


; INSTRUMENTTIEN FORMAATTI: (hieanot lyhenteet!!!)
;   LVL, ATT, DCY, STN, RLS, MDE, 4SLDHI:4ARL, SLD, NSD, AR0, AR1, AR2,..,AR6
;

instrumentit:   ; 16*16 = 256 tavua
.db 0C0h,0FFh,00Ah,080h,050h,008h,001h,000h,000h,0,0,0,0,0,0,0 ; i 0, basso
.db 0B0h,090h,00Fh,070h,020h,008h,001h,000h,000h,0,0,0,0,0,0,0 ; i 1, melodia
.db 050h,080h,003h,000h,010h,008h,004h,000h,000h,0,3,7,12,0,0,0 ; i 2 B hilj
.db 080h,080h,007h,000h,010h,008h,004h,000h,000h,0,4,7,9,0,0,0 ; i 3 ruuri 6
.db 0A0h,080h,008h,000h,007h,008h,004h,000h,000h,0,3,5,8,0,0,0 ; i 4 molli7/7
.db 0A0h,080h,008h,000h,007h,008h,004h,000h,000h,0,3,7,10,0,0,0 ; i 5 molli7
.db 0C0h,0F0h,014h,000h,040h,000h,002h,0F0h,000h,0,11,0,0,0,0,0 ; i 6, virveli
.db 090h,0F0h,034h,000h,040h,000h,001h,030h,000h,0,0,0,0,0,0,0 ; i 7, "rumpu"
.db 070h,0F0h,044h,000h,040h,000h,001h,030h,000h,0,0,0,0,0,0,0 ; i 8, "rumpu"
.db 090h,0F0h,009h,000h,040h,000h,001h,030h,000h,0,0,0,0,0,0,0 ; i 9, "haikka"
.db 0B0h,0FFh,00Ah,040h,050h,008h,001h,000h,000h,0,0,0,0,0,0,0 ; i A, pikkubas
.db 0A0h,080h,008h,000h,010h,008h,004h,000h,000h,0,3,7,12,0,0,0 ; i B molli
.db 0A0h,080h,007h,000h,010h,008h,004h,000h,000h,0,4,5,9,0,0,0 ; i C maj7/7
.db 0A0h,080h,007h,000h,010h,008h,004h,000h,000h,0,3,5,9,0,0,0 ; i D 7/7
.db 080h,080h,007h,000h,010h,008h,004h,000h,000h,0,3,6,8,0,0,0 ; i E 7/4 hilj
.db 040h,001h,001h,000h,010h,008h,001h,000h,000h,0,0,0,0,0,0,0 ; i F slow att.
; ---- that's all... ----


kanavien_parametrit:
kanavan_0_parametrit:
.dw instrumentit, raita0-1, alkupatterni
.db 0,0,0,0,0,0,0,3 ; ensimminen on offs. 6
.db 1,0,0,0,0,0,0,0 ; viimeinen on offs. 21
.db 0,0,0,0,0,0,0,0 ; ensimminen on offs. 22
kanavan_1_parametrit:
.dw instrumentit, raita1-1, alkupatterni
.db 0,0,0,0,0,0,0,3 ; viimeinen on offs. 13
.db 1,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0 ; ensimminen on offs. 22
kanavan_2_parametrit:
.dw instrumentit, raita2-1, alkupatterni
.db 0,0,0,0,0,0,0,3
.db 1,0,0,0,0,0,0,0
.db 0,0,0,0,0,0,0,0 ; ensimminen on offs. 22



; ------------------------------- SONG ORDER ------------------------------

raita0:  ; ------ basso+rumpu -raita
.db 0, 0, 1, 3, 4
.db TRACK_SETREPEAT
.db 0, 0, 0, 0, 1, 1, 0, 0, 3, 1, 0, 2
.db TRACK_REPEAT, TRACK_INF
.db VIIMPATT, TRACK_STOP

raita1:  ; ------- arpeggioraita
.db 10, 10, 11, 13, 5
.db TRACK_SETREPEAT
.db 10, 10, 10, 10, 11, 11, 10, 10, 13, 11, 10, 12
.db TRACK_REPEAT, TRACK_INF
.db VIIMPATT, TRACK_STOP

raita2:  ; ------- melodiaraita
.db TRACK_SETREPEAT, 14, TRACK_REPEAT,7,  6
;.db TRACK_SETREPEAT, 14, TRACK_REPEAT,2+23 ; taukoa
.db TRACK_SETREPEAT
.db 20, 19  ; D-molli,  19 on tyhj pala
.db 22, 20, 21
.db 20, 19, 23, 24, 25  ; G-molli
.db 14, 14 ; loppu tyteen
.db TRACK_REPEAT,TRACK_INF
.db VIIMPATT, TRACK_STOP


alkupatterni:
.db NOTE_OFF, 4
.db END_PATTERN

#include "commands.inc"

; rumpujen korkeudet
#define nSD 35
#define nDR 48
#define nHH 40

; -------------------------------- PATTERNIT! -------------------------------

patt00: ; ------------- PATTERN 00 ------------
        ; --- Bassoa ja rumpuja         Dm
        .db nD1,004h,  nDR,072h,  nD1,002h
        .db nSD,062h,  nDR,082h
        .db nDR,072h
        .db nD1,002h,  NOTE_OFF,002h,  nD1,002h,  nDR,072h
        .db nD1,0A2h,  nSD,064h,  nF1,002h,  nDR,082h
        .db END_PATTERN
patt01: ; ------------- PATTERN 01 ------------
        ; --- Bassoa ja rumpuja         Gm
        .db nG1,004h,  nDR,072h,  nG1,002h
        .db nSD,062h,  nDR,082h
        .db nDR,072h
        .db nG1,002h,  NOTE_OFF,002h,  nG1,002h,  nDR,072h
        .db nD1,0A2h,  nSD,062h,  nF1,002h,  nHH,092h, nF1,002h
        .db END_PATTERN
patt02: ; ------------- PATTERN 02 ------------
        ; --- Bassoa ja rumpuja         Em-D#m
        .db nE1,002h,  nDR,072h,  nE2,004h
        .db nSD,062h,  nDR,082h
        .db nE1,004h
        .db nDis1,002h,  nDR,072h,  nDis2,002h,
        .db nDis1,0A2h,  nSD,062h,  nDis1,002h,  nHH,092h, nDR,082h
        .db END_PATTERN
patt03: ; ------------- PATTERN 03 ------------
        ; --- Bassoa ja rumpuja         A
        .db nA1,004h,  nDR,072h,  nA1,002h
        .db nSD,062h,  nDR,082h
        .db nDR,072h
        .db nA1,002h,  NOTE_OFF,002h,  nA1,002h,  nDR,072h
        .db nA1,0A2h,  nSD,064h,  nF1,002h,  nDR,082h
        .db END_PATTERN

patt04: ; ---- alkufilli basso
        .db nD1,001h, NOTE_OFF,1
        .db nD1,001h, NOTE_OFF,3
        .db nD1,001h, NOTE_OFF,3
        .db nD1,001h, NOTE_OFF,3
        .db nC1,001h, NOTE_OFF,1
        .db nD1,001h, NOTE_OFF,7
        .db DELAY,8
        .db END_PATTERN
patt05: ; ---- alkufilli arpeggiot
        .db nD4,0B2h
        .db nD4,024h
        .db nD4,0B4h
        .db nD4,0B4h
        .db nC4,032h
        .db nD4,0B8h
        .db DELAY,8
        .db END_PATTERN
patt06: ; ---- alkufilli rummut
        .db nD4,062h
        .db nD4,064h
        .db nD4,064h
        .db nD4,064h
        .db nC4,062h
        .db nD4,064h,
        .db nG4,0F0h, SLIDE_UP,1,12
        .db END_PATTERN
patt07:
patt08:
patt09: .db END_PATTERN
patt10: ; ---------- pattern 10 -------------
        ; ----- sointuja                Dm
        .db nD4,024h
        .db nD4,0B4h, nC4,034h
        .db nD4,054h, nD4,024h
        .db nD4,0B4h, nC4,034h
        .db nD4,054h
        .db END_PATTERN
patt11:
        ; ----- sointuja                Gm
        .db nG3,024h
        .db nF4,0C4h, nC4,034h
        .db nD4,044h, nG3,024h
        .db nF4,0C4h, nC4,034h
        .db nD4,044h
        .db END_PATTERN
patt12:
        ; ----- sointuja                Em-D#
        .db NOTE_OFF,004h, (nE4),058h, (nE4),058h
        .db (nDis4),058h, (nDis4),054h
        .db END_PATTERN
patt13:
        ; ----- sointuja                A7
        .db nA3,024h
        .db nE4,0D4h, nCis4,0E4h
        .db nE4,0D4h, nA3,024h
        .db nE4,0D4h, nCis4,0E4h
        .db nE4,0D4h
        .db END_PATTERN
patt14: ; ---- odottelupatterni
        .db DELAY,8,  DELAY,8
        .db END_PATTERN
patt15: ; -----viuuuuuuu.....
;        .db nE1,0F1h,  SLIDE_UP,1,15
;        .db END_PATTERN
patt16:
        .db END_PATTERN
patt17:
patt18:
patt19: .db DELAY, 4 ; meill on ts pien tauko
        .db END_PATTERN

; 2617892 /hese

patt20: ; ---- melodiaa ----
        .db nD4,012h, VIBRATO,7, DELAY,4, NOTE_OFF,2
        .db nG4,010h, SLIDE_UP,2,2, PORTAMENTO+nG4,2
        .db nF4,012h, nG4,012h, NOTE_OFF,2
        .db nG4,010h, SLIDE_UP,2,3, PORTAMENTO+nA4,3
        .db VIBRATO,7, DELAY,2, NOTE_OFF,2
        .db END_PATTERN
patt21: ; ---- melodiaa ----
        .db nD5,012h, VIBRATO,7, DELAY,2,
        .db nC5,012h, NOTE_OFF,2,
        .db nA4,012h, NOTE_OFF,2,
        .db nGis4,012h, nG4,012h,
        .db nF4,012h, PORTAMENTO+nD4,2,
        .db VIBRATO,7, VIBRATO,7, DELAY,12, NOTE_OFF,4
        .db END_PATTERN
patt22:
        .db NOTE_OFF, 4
        .db nD4,012h, VIBRATO,7, NOTE_OFF,2,
        .db nG4,010h, SLIDE_UP,2,2, PORTAMENTO+nG4,2
        .db nC5,012h, nD5,012h, NOTE_OFF,2
        .db nGis4,010h, SLIDE_DOWN,1,4, PORTAMENTO+nF4,2
        .db VIBRATO,7, DELAY,4, NOTE_OFF,4
        .db END_PATTERN
patt23: .db nG4,012h, NOTE_OFF,2, nG4,012h
        .db nA4,012h, NOTE_OFF,2, nA4,012h, NOTE_OFF,2
        .db nAis4,012h, NOTE_OFF,2, nAis4,012h, NOTE_OFF,2
        .db nC5,010h, SLIDE_UP,1,2, VIBRATO,7, PORTAMENTO+nD5,4
        .db nC5,012h, nAis4,12h
        .db END_PATTERN
patt24:
        .db nG4,010h, SLIDE_UP,1,2, VIBRATO,2, PORTAMENTO+nA4,4
        .db VIBRATO,4, DELAY,4, VIBRATO,7, DELAY,14
        .db NOTE_OFF,0, SLIDE_DOWN,5,2
        .db nF4,012h, NOTE_OFF,2, nG4,012h, NOTE_OFF,2
        .db nA4,012h, VIBRATO,7, DELAY,8, NOTE_OFF,12
        .db END_PATTERN
patt25: .db nD4,012h, PORTAMENTO+nF4,2
        .db nG4,012h, PORTAMENTO+nA4,2
        .db nC5,010h, SLIDE_UP,2,1, VIBRATO,7, PORTAMENTO+nCis5,1
        .db PORTAMENTO+nA4,2, nA4,012h, NOTE_OFF,2
        .db nA4,012h, NOTE_OFF,2
        .db NOTE_OFF,4, nA4,012h, NOTE_OFF,2
        .db nG4,012h, VIBRATO,7, DELAY,2, NOTE_OFF,2
        .db nA4,012h, VIBRATO,7, DELAY,2, NOTE_OFF,2
        .db nA4,010h, SLIDE_UP,1,2, VIBRATO,7, PORTAMENTO+nAis4,2
        .db SLIDE_DOWN,1,4, nG4,014h,
        .db NOTE_OFF,4, nA4,012h, PORTAMENTO+nG4,2
        .db nG4,010h, SLIDE_UP,1,2, VIBRATO,7, PORTAMENTO+nA4,4
        .db PORTAMENTO+nF4,6, nD4,012h, VIBRATO,7, DELAY,14, NOTE_OFF,4
        .db DELAY,12
        .db END_PATTERN
patt26:
patt27:
patt28:
patt29:
vimopat: .db nC3,064h, NOTE_OFF, 8, END_PATTERN

pattern_addr:
.dw     patt00
.dw     patt01
.dw     patt02
.dw     patt03
.dw     patt04
.dw     patt05
.dw     patt06
.dw     patt07
.dw     patt08
.dw     patt09
.dw     patt10
.dw     patt11
.dw     patt12
.dw     patt13
.dw     patt14
.dw     patt15
.dw     patt16
.dw     patt17
.dw     patt18
.dw     patt19
.dw     patt20
.dw     patt21
.dw     patt22
.dw     patt23
.dw     patt24
.dw     patt25
.dw     patt26
.dw     patt27
.dw     patt28
.dw     patt29
viimeinenp:
.dw     vimopat

vibrato_table:  ; mistkhn t on... pituutta 128 tavua!
.dw    0,24/64,49/64,74/64,97/64,120/64,141/64,161/64,
.dw    180/64,197/64,212/64,224/64,235/64,244/64,250/64,253/64
.dw    255/64,253/64,250/64,244/64,235/64,224/64,212/64,197/64
.dw    180/64,161/64,141/64,120/64,97/64,74/64,49/64,24/64
.dw    0,-24/64,-49/64,-74/64,-97/64,-120/64,-141/64,-161/64
.dw    -180/64,-197/64,-212/64,-224/64,-235/64
.dw    -244/64,-250/64,-253/64,-255/64,-253/64,-250/64
.dw    -244/64,-235/64,-224/64,-212/64,-197/64
.dw    -180/64,-161/64,-141/64,-120/64
.dw    -97/64,-74/64,-49/64,-24/64

.end
; LOP-BU
